<?php
/*
  This hook will process strings looking like e-mail addresses (a@b.[..|...]) and replace
  with something less obvious for spambots.

  It cannot be disabled from within document (e.g. by using an action) - if it's loaded
  it'll always work.

  CONFIGURATION - fields added to UWikiSettings:

    * EMailMaskingScope:
      = "any" (default) == will process all source text disregarding parts that might be in
        different markups (so normal text, embedded code, escaping (~ or "") are all ignored).
      = "wacko" will add a handler to the wacko formatter that will only operate on wiki docs.
        # NOTE: for this mode to work you need to put the second part of this script (named
                "mask wacko e-mails.php" by default) into wacko/ directory.

    * EMailMask - a string with "\1", "\2" & "\3" standing for user, domain and root domain
      correspondingly. Default value is "\1 at \2.\3" so that: you@us.net -> you at us.net.
      * if EMailMaskingScope is set to "wacko" this setting can take value of "javascript"
        or "js" to move into the most disguising mode that spammers can't handle at all;
        however, users that have JS disabled will see an error message instead of the e-mail.
*/

UWikiDocument::$setSourceHooks[] = 'MaskEMailsInUWikiDocument';

  function MaskEMailsInUWikiDocument(&$source, $doc) {
    if (!defined('DefaultEMailMask')) {
      define('DefaultEMailMask', '\1 at \2.\3');

      $lb = UWikiLeftWordBoundary;
      $rb = UWikiRightWordBoundary;
      $l  = 'a-zA-Z';
      $w  = "0-9\-.$l";

      define('MaskEMails_1', "(?<=$lb)[$l][_$w]{0,40}");
      define('MaskEMails_2', "[$l][$w]{0,30}");
      define('MaskEMails_3', "[$l]{2,5}(?=$rb)");
    }

    $scope = &$doc->settings->EMailMaskingScope;
    isset($scope) or $scope = 'any';

    if ($scope !== 'wacko') {
      $mask = &$doc->settings->EMailMask;
      isset($mask) or $mask = DefaultEMailMask;

      $regexp = '/('.MaskEMails_1.')@('.MaskEMails_2.')\.('.MaskEMails_3.')/u';
      $source = preg_replace($regexp, $mask, $source);
    }
  }


UWikiDocument::$beforeParsingHooks[] = 'PrepareEMailMaskingInUWikiDocument';

  function PrepareEMailMaskingInUWikiDocument($doc) {
    $scope = &$doc->settings->EMailMaskingScope;
    if ($scope === 'wacko' and $doc->settings->markupName === 'wacko') {
      // handlers' regexp must not contain any capturing brackets
      $email = array(MaskEMails_1.'@'.MaskEMails_2.'.'.MaskEMails_3, 'Uwacko_MaskEMails', Uwacko_SingleTag);
      $doc->settings->handlers->AddTo('inline', $email);
    }
  }
